#include <stdio.h>
#include <time.h>
#include <io.h>
#include "typedef.h"

struct pat {
	struct pat far *nxt;
	char far *bdir;
	char far *fname;
	int cnt;
	char far pname[1];
};

#ifndef __TURBOC__
struct ftime	{
	uint	ft_tsec	 : 5;	/* Two second interval */
	uint	ft_min	 : 6;	/* Minutes */
	uint	ft_hour	 : 5;	/* Hours */
	uint	ft_day	 : 5;	/* Days */
	uint	ft_month : 4;	/* Months */
	uint	ft_year	 : 7;	/* Year */
};
#endif

struct datetime {
	ushort time;
	ushort date;
};

union stamp {					/* time stamp */
	ulong u;
	struct ftime s;
	struct datetime t;
};

struct head {
	int			headersize;
	char 		method[6];
	ulong		packed;
	ulong		skip;
	ulong		original;
	union stamp	dostime;
	time_t		utc;
	int			attr;
	int			level;
	uint		filecrc;
	uint		headcrc;
	int			dos;
	char		*pathname;
	char		*filename;
	int			dirnlen;
	int			filenlen;
	int			info;
	long		currentpos;
	char		*crcpos;
};

struct fb {					/* file name buffer */
	struct fb far *nxt;
	char far *cpos;					/* position of effective path name */
	char far *fpos;					/* position of file name */
	long time;
	char used;
	char far fname[1];
};

#define iskanji(c) ((uchar)(c) >= 0x80 && \
                    (uchar)(c) <= 0x9f || \
                    (uchar)(c) >= 0xe0 && \
                    (uchar)(c) <= 0xfd    )
#define DELIM ('/')
#define DELIM2 (0xffu)
#define DELIMSTR "/"

#if 0
struct srchblk {
	char  *sb_name;
	int    sb_attrib;
	time_t sb_ftime;
	long   sb_fsize;
	void  *sb_buf;
};
#endif

/* from mn.c */
#define MAX_PATH 80

extern char arcname[MAX_PATH];
extern char filename1[MAX_PATH];
extern char filename2[MAX_PATH];
extern char filename3[MAX_PATH];
extern FILE *file1, *file2, *file3;
extern int  cmdupdate;
extern char workdir[];
#if 0
extern char *pager;
extern char *keyword;
#endif
extern char cmd;
extern char lhtmp1[], lhtmp2[];
extern char work[];
extern int errorlevel;
extern int outredir;

void usage(void);
void update_arcstamp(void);

/* from append.c */
void copylzh(void);
void regext(char *ext);
void freeze(char *path, char *name);
int append(void);
int endappend(void);
void deletefiles(void);
int freshen(char far *bdir);

/* from extract.c */
void extract(char far *bdir);
void extract_internal(FILE *f, char *p);

/* from list.c */
void initlist(void);
void list(void);
void endlist(time_t arctime);

/* from match.c */
extern struct pat far *pbuf;

void initpat(void);
void regpat(char *pattern, char far *bdir);
char far *regbdir(char *bdir);
char *matchfname(char far *pname, char *fname);
char far *matchpat(char *path);
int tstpat(void);

/* from header.c */
extern struct head hpb;

ulong inithdr(void);
char *gethdr(int *err);
void makehdr(void);
void writehdr(void);
void adjusthdr(void);

/* from files.c */
extern struct fb far *fbuf;

void mklist(void);
struct fb far *searchfile(char *path);

/* from getopt.c */
extern char	flg_r, flg_p, flg_x, flg_m, flg_a, flg_c, flg_n, flg_t, flg_u,
            flg_v, flg_w, flg_i, flg_h, flg_o, flg_z, flg_l, flg_at;

int getopt(char *p);

/* from util.c */
extern uchar pathdelim;
extern uchar swchar;

char *convdelim(char *path, char delim);
char *getfilename(char *path);
char *backpath(char *p);
int getyn(void);
void getswchar(void);
time_t dos2unix(struct ftime *ft);
struct ftime *unix2dos(time_t utc);
int ratio(ulong a, ulong b, int ord);
void copyfile(FILE *f1, FILE *f2, long size, int crc_flg);
void far *e_farmalloc(ulong size);
void *e_malloc(uint size);
void *e_realloc(void *buf, int size);
FILE *myeopen(char *path, char *mode, char *errmes);
FILE *mywopen(char *path, char *errmes);
FILE *myropen(char *path);
void eprintf(char *fmt, ...);

/* from dosio.c */
time_t getfiletime(FILE *f);
int setfiletime(FILE *f, time_t utc);
long diskspace(char *filename);

#define makedir(c) mkdir(c)

/* from error.c */
void error(char *errmes, char *p);
void fileerror(char *err, FILE *file);
void userbreak(int code);
void initbreak(void);

/* from path.c */
void form_path(char *p);

/* from self.c */
void initsfx(void);
int copysfx(void);
void makesfx(char far *bdir);
